﻿/*　概要ここから
クラス名：acs.Modt001
変換ボタン及び二つのテキスト入力領域への参照を引数として受け取る。
変換ボタンを押した際、一つ目のテキスト入力領域内の文字列を変換して、その結果を二つ目のテキスト入力領域内に表示する。
変換のルールは下記の通りである。
urlを見つけた場合　<a href="url">url</a>
メールアドレスを見つけた場合　<a href="mailto:メールアドレス">メールアドレス</a>
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import flash.display.MovieClip;
	import flash.events.MouseEvent;

	public class Modt001 {
		var button_mc:MovieClip;//変換ボタンMCインスタンス取得用
		var text1_ob:Object;//変換前テキスト入力インスタンス取得用
		var text2_ob:Object;//変換後テキスト入力インスタンス取得用

		//url変換用正規表現パターン及び置換後文字列
		var url_re:RegExp = /http:\/\/[-a-zA-Z0-9_.\/]+/g;
		var url_st:String = "<a href=\"$&\">$&</a>";

		//メールアドレス変換用正規表現パターン及び置換後文字列
		var mail_re:RegExp = /[-a-zA-Z0-9_.]+@[-a-zA-Z0-9_.]+/g;
		var mail_st:String = "<a href=\"mailto:$&\">$&</a>";

		//コンストラクタ
		//引数は変換ボタンのムービークリップ、二つのテキスト入力領域への参照
		function Modt001(button:MovieClip , text1:Object , text2:Object) {
			button_mc = button;//変換ボタンMCインスタンスへの参照を取得
			button_mc.buttonMode = true;//マウスカーソルの形状変更
			text1_ob = text1;//変換前テキスト入力インスタンスへの参照を取得
			text2_ob = text2;//変換後テキスト入力インスタンスへの参照を取得
			button_mc.addEventListener(MouseEvent.CLICK , clickF);//マウスイベント定義
		}

		//クリック時関数
		function clickF(event:MouseEvent):void {
			var temp_st:String;//文字列一時格納用
			temp_st = text1_ob.text;//変換前文字列取得
			temp_st = temp_st.replace(url_re , url_st);//url変換
			temp_st = temp_st.replace(mail_re , mail_st);//mailアドレス変換
			text2_ob.text = temp_st;//変換後文字列に代入
		}
	}
}