﻿/*　概要ここから
クラス名：acs.Modt003
XMLファイルのurl(1個以上)を引数として受け取る
そのXMLファイル内に書かれている内容をリンク形式に変更する。
public function getStringFにて指定された番号(0～)のStringデータをreturnする。

本クラス内にて使用しているXmlLoadは配布サンプルmodt002に含まれるものと同様である。
コンストラクタにて引数として受け取ったURL格納配列を元にXMLファイルをロードする
public function getDataFにて指定された番号(0～)のXMLデータをreturnする。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.XmlLoad;
	import flash.events.Event;
	import flash.events.EventDispatcher;

	//dispatchEventのためにEventDispatcherを継承
	public class Modt003 extends EventDispatcher{

		//dispatchEventにて使用
		public static const CHANGECOMPLETE:String = "changecomplete";

		var data_num:int;//ロードするXMLファイル数	
		var xmlLoad:XmlLoad;//XmlLoadクラスインスタンス 
		var stringdata_arr:Array = new Array();//変換後Stringデータ格納
		var xmldata:XML;//XMLファイルのデータ格納

		//コンストラクタ
		//引数として受け取るのはxmlファイルのURLを格納した文字列配列
		function Modt003(url_arr:Array){
			data_num = url_arr.length;//XMLファイル数保存

			//XmlLoadクラスインスタンス生成
			xmlLoad = new XmlLoad(url_arr);
		}

		//処理開始関数
		public function init():void{
			//ロード完了イベントを設定
			xmlLoad.addEventListener(XmlLoad.LOADCOMPLETE,xmlLoadF);

			//処理開始
			xmlLoad.init()
		}

		//ロード完了イベント取得時関数
		function xmlLoadF(event:Event):void{

			//xmlデータを一つ目から順番に見ていく
			for(var i:int = 0 ; i < data_num ; i++){
				//i番目のXMLファイルからデータを取得
				xmldata = xmlLoad.getDataF(i);
				stringdata_arr[i] = "";//文字列初期化

				//xmlデータの中から<linkdata>～</linkdata>を取得
				for each(var tempxml:XML in xmldata.linkdata){
					//<linkdata>～</linkdata>内の各要素の取得
					//取得したデータを元にhtml形式を作成する
					var url:String = tempxml.url.toString();
					var title:String = tempxml.title.toString();
					var review:String = tempxml.review.toString();
					stringdata_arr[i] += "<font color=\"#ff0000\"><a href=\"" + url + "\">" + title + "</a></font>" +"\n" + review +"\n\n";
				}
			}
			//全XMLデータの変換処理終了イベント
			//本クラスのインスタンス生成元はこのイベントを取得して処理完了を知る
			dispatchEvent(new Event(Modt003.CHANGECOMPLETE));
		}

		//Stringデータ取得用関数
		//引数として受け取った数が示す番号(0～)のXMLデータをを元にしたStringをreturn
		public function getStringF(i:int):String{
			return stringdata_arr[i];
		}
	}
}