﻿/*　概要ここから
クラス名：acs.ImageLoad
XMLファイルのurl(1個以上)を引数として受け取る
XMLファイル内に書かれているURLを元に画像をロードする。
ロードした画像は、すべて一つの配列内に順番に格納する
(一つ目のXMLファイル内の最後のURLの次は二つ目のXMLファイル内の最初のURL)。
public function getImageFにてLoaderを格納した配列をreturnする。

本クラス内にて使用しているXmlLoadは配布サンプルmodt002に含まれるものと同様である。
コンストラクタにて引数として受け取ったURL(数量可変)を元にXMLファイルをロードする。
public function getDataFにて指定された番号(0～)のXMLデータをreturnする。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.XmlLoad;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.net.URLRequest;
	import flash.display.Loader;

	//dispatchEventのためにEventDispatcherを継承
	public class ImageLoad extends EventDispatcher{

		//dispatchEventにて使用
		public static const IMAGELOADCOMPLETE:String = "imageloadcomplete";

		var data_num:int;//ロードするXMLファイル数
		var image_num:int = 0;//ロードする画像枚数
		var image_cnt:int = 0;//ロード完了した枚数

		var xmlLoad:XmlLoad;//XmlLoadインスタンス用
		var xmldata:XML;//xmlデータ格納用
		var url_req:URLRequest;//xmlファイルロード用
		var imageLoader:Loader;//Loaderクラスインスタンス
		var imagedata_arr:Array = new Array();//ロード後画像格納

		//コンストラクタ
		//引数として受け取るのはXMLファイルのURL(String　数量可変)
		function ImageLoad(url_arr:Array){
			data_num = url_arr.length;//XMLファイル数保存

			xmlLoad = new XmlLoad(url_arr);//XmlLoadクラスインスタンス生成

			//ロード完了イベントを設定
			xmlLoad.addEventListener(XmlLoad.LOADCOMPLETE,xmlLoadF);
		}

		//処理開始関数
		public function init():void{
			//処理開始
			xmlLoad.init();
		}

		//XML読み込み完了イベント取得時関数
		function xmlLoadF(event:Event):void{
			var start_cnt:int = 0;//ロード開始画像枚数

			//全画像数取得
			for(var m:int = 0 ; m < data_num ; m++){
				xmldata = xmlLoad.getDataF(m);
				for each(var tempurl:XML in xmldata.url){
					image_num++;
				}
			}

			//xmlデータを一つ目から順番に見ていく
			for(var i:int = 0 ; i < data_num ; i++){
				//i番目のXMLデータを取得
				xmldata = xmlLoad.getDataF(i);

				//xmlデータの中から<url>～</url>を取得
				//取得したURLを元にしてLoaderクラスで画像をロードする
				for each(var tempxml:XML in xmldata.url){
					imageLoader = new Loader();
					url_req = new URLRequest(tempxml.toString());
					imagedata_arr.push(imageLoader);
					imagedata_arr[start_cnt].contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoadF); 
					imagedata_arr[start_cnt].load(url_req);
					start_cnt++;
				}
			}
		}

		//各画像ロード完了取得関数
		function imageLoadF(event:Event):void{
			image_cnt++;//ロード済み画像数を増やす

			//画像ロード完了時、イベント配信
			//生成元はこのイベントを取得して完了を知る
			if(image_cnt > image_num - 1)
			dispatchEvent(new Event(ImageLoad.IMAGELOADCOMPLETE));
			
		}

		//画像データ配列への参照を渡す
		public function getImageF():Array{
			return imagedata_arr;
		}

		//ロードする画像枚数を渡す
		public function getImagenumF():int{
			return image_num;
		}

		//ロード完了した画像枚数を渡す
		public function getImagecntF():int{
			return image_cnt;
		}
	}
}