﻿/*　概要ここから
クラス名：acs.Modt004
XMLファイルのurl(1個以上)を引数として受け取る
XMLファイル内に書かれているURLを元にImageLoadクラスを使用して画像をロードする。
ロードした画像を使用し、クリックする度に次画像が表示される画像ビューアを作成する。
最終画像の次は最初の画像に戻る。

ImageLoadクラス及びXmlLoadクラスについては各asファイルを参照。
XmlLoadは配布サンプルmodt002に含まれるものと同様である。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.ImageLoad;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;

	//MovieClipはEventDispatcherを継承しているためdispatchEvent使用可能
	public class Modt004 extends MovieClip{

		//dispatchEventにて使用
		public static const MODT004COMPLETE:String = "modt004complete";

		var area_width:int = 0;//表示する領域の横幅
		var area_height:int = 0;//表示する領域の縦幅
		var image_num:int = 0;//ロードする画像ファイル数

		var imageLoad:ImageLoad;//ImageLoad用
		var image_arr:Array = new Array();//画像格納用

		var loading_text:TextField = new TextField();//ロード状況表示用

		var nowN:int = 0;//現在表示している画像ナンバー（0～）

		//コンストラクタ
		//表示する領域の横幅と縦幅を引数として受け取る
		//配列として受け取っているのはXMLファイルのURL
		function Modt004(w:int , h:int , url_arr:Array){
			area_width = w;
			area_height = h;

			//ImageLoadクラスインスタンス生成
			imageLoad = new ImageLoad(url_arr);
		}

		//処理開始関数
		public function init():void{
			//ロード完了イベントを設定
			imageLoad.addEventListener(ImageLoad.IMAGELOADCOMPLETE,imageLoadF);

			//処理開始
			imageLoad.init();

			//テキストフィールドサイズ変更と表示
			loading_text.width = area_width;
			this.addChild(loading_text);

			//エンターフレームイベント生成
			this.addEventListener(Event.ENTER_FRAME , enterFrameF);
		}

		//画像読み込みの進度を表示するために使用
		//now Loading……　読込完了画像数　／　全画像数
		function enterFrameF(event:Event):void{
			loading_text.x = loading_text.y = 0;//左上に配置

			//全画像数及び読込完了画像数取得
			var temp_num:int = imageLoad.getImagenumF();
			var temp_cnt:int = imageLoad.getImagecntF();

			//テキストフィールド内容更新
			loading_text.text = "now Loading……  " + temp_cnt + "　／　" + temp_num; 
		}


		//画像読み込み完了イベント取得時関数
		function imageLoadF(event:Event):void{

			//imageLoadクラスインスタンスの画像を配列に格納する
			image_arr = imageLoad.getImageF();

			//画像枚数取得
			image_num = imageLoad.getImagenumF();

			//位置設定用関数呼び出し
			adjustImageF();
		}

		//画像位置設定用関数
		function adjustImageF():void{
			for(var i:int = 0 ; i<image_num ; i++){
				//visible false
				image_arr[i].visible = false;

				//表示ツリー構造に追加
				this.addChild(image_arr[i]);

				//表示領域よりサイズが大きい場合に縮小
				if(image_arr[i].width > area_width || image_arr[i].height > area_height ){
					if(image_arr[i].width / area_width > image_arr[i].height / area_height){
						image_arr[i].height *= area_width / image_arr[i].width;
						image_arr[i].width = area_width;
					}
					else{
						image_arr[i].width *= area_height / image_arr[i].height;
						image_arr[i].height = area_height;
					}
				}

				//表示領域の中央に移動
				image_arr[i].x += (area_width - image_arr[i].width)/2;
				image_arr[i].y += (area_height - image_arr[i].height)/2;
			}

			//エンターフレームイベント削除
			this.removeEventListener(Event.ENTER_FRAME , enterFrameF);

			//テキストフィールド表示終了
			this.removeChild(loading_text);

			//マウスカーソルの形状変更
			this.buttonMode = true;

			//クリックイベント追加
			this.addEventListener(MouseEvent.CLICK , clickF);

			//最初の画像のみ可視とする
			image_arr[nowN].visible = true;

			//初期処理完了イベント配信
			//生成元はこのイベントを取得して処理完了を知る。
			dispatchEvent(new Event(Modt004.MODT004COMPLETE));
		}

		//クリック時イベント
		//表示する画像の切り替えを行う
		function clickF(event:MouseEvent):void{
			image_arr[nowN].visible = false;
			nowN++;
			if(nowN > image_num - 1)nowN = 0;
			image_arr[nowN].visible = true;
		}
	}
}