﻿/*　概要ここから
クラス名：acs.Modt005
XMLファイルのurl(1個以上)を引数として受け取る
XMLファイル内に書かれているURLを元にImageTextLoadクラスを使用して画像をロードする。
ロードした画像を使用し、クリックする度に次画像が表示される画像ビューアを作成する。
その際、画像下部に画像毎の説明文も表示する。
最終画像の次は最初の画像に戻る。

ImageLoadクラス及びXmlLoadクラスについては各asファイルを参照。
XmlLoadは配布サンプルmodt002に含まれるものと同様である。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.ImageTextLoad;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;

	//MovieClipはEventDispatcherを継承しているためdispatchEvent使用可能
	public class Modt005 extends MovieClip{

		//dispatchEventにて使用
		public static const MODT005COMPLETE:String = "modt005complete";

		var area_width:int = 0;//表示する領域の横幅
		var area_height:int = 0;//表示する領域の縦幅
		var image_num:int = 0;//ロードする画像ファイル数

		var imageTextLoad:ImageTextLoad;//ImageTextLoad用
		var image_arr:Array = new Array();//画像格納用
		var text_arr:Array = new Array();//説明文格納用

		var loading_text:TextField = new TextField();//ロード状況及び説明文表示用

		var nowN:int = 0;//現在表示している画像ナンバー（0～）

		//コンストラクタ
		//表示する領域の横幅、縦幅を引数として受け取る
		//ここで縦幅は説明文表示分を省いた値とする
		//配列として受け取っているのはXMLファイルのURL
		function Modt005(w:int , h:int , url_arr:Array){
			area_width = w;
			area_height = h;

			//ImageTextLoadクラスインスタンス生成
			imageTextLoad = new ImageTextLoad(url_arr);
		}

		//処理開始関数
		public function init():void{			
			//ロード完了イベントを設定
			imageTextLoad.addEventListener(ImageTextLoad.IMAGETEXTLOADCOMPLETE,imageTextLoadF);

			//処理開始
			imageTextLoad.init();

			//テキストフィールドサイズ変更と表示
			loading_text.width = area_width;
			this.addChild(loading_text);

			//エンターフレームイベント生成
			this.addEventListener(Event.ENTER_FRAME , enterFrameF);
		}

		//画像読み込みの進度を表示するために使用
		//now Loading……　読込完了画像数　／　全画像数
		function enterFrameF(event:Event):void{
			loading_text.x = loading_text.y = 0;//左上に配置

			//全画像数及び読込完了画像数取得
			var temp_num:int = imageTextLoad.getImagenumF();
			var temp_cnt:int = imageTextLoad.getImagecntF();

			//テキストフィールド内容更新
			loading_text.text = "now Loading……  " + temp_cnt + "　／　" + temp_num; 
		}


		//画像読み込み完了イベント取得時関数
		function imageTextLoadF(event:Event):void{

			//imageTextLoadクラスインスタンスの画像を配列に格納する
			image_arr = imageTextLoad.getImageF();

			//説明文を配列に格納する
			text_arr = imageTextLoad.getTextF();

			//画像枚数取得
			image_num = imageTextLoad.getImagenumF();

			//位置設定用関数呼び出し
			adjustImageF();
		}

		//画像位置設定用関数
		function adjustImageF():void{
			for(var i:int = 0 ; i<image_num ; i++){
				//visible false
				image_arr[i].visible = false;

				//表示ツリー構造に追加
				this.addChild(image_arr[i]);

				//表示領域よりサイズが大きい場合に縮小
				if(image_arr[i].width > area_width || image_arr[i].height > area_height ){
					if(image_arr[i].width / area_width > image_arr[i].height / area_height){
						image_arr[i].height *= area_width / image_arr[i].width;
						image_arr[i].width = area_width;
					}
					else{
						image_arr[i].width *= area_height / image_arr[i].height;
						image_arr[i].height = area_height;
					}
				}

				//表示領域の中央に移動
				image_arr[i].x += (area_width - image_arr[i].width)/2;
				image_arr[i].y += (area_height - image_arr[i].height)/2;
			}

			//エンターフレームイベント削除
			this.removeEventListener(Event.ENTER_FRAME , enterFrameF);

			//テキストフィールドを下部に移動
			loading_text.y = area_height;

			//テキストフィールドのフォーマット変更
			var format:TextFormat = new TextFormat();
			format.align = TextFieldAutoSize.CENTER;
			format.color = 0x888888;
			format.size = 18;
			loading_text.selectable = false;
			loading_text.defaultTextFormat = format;

			//テキストフィールドに最初の説明文表示
			loading_text.text = text_arr[nowN];

			//マウスカーソルの形状変更
			this.buttonMode = true;

			//クリックイベント追加
			this.addEventListener(MouseEvent.CLICK , clickF);

			//最初の画像のみ可視とする
			image_arr[nowN].visible = true;

			//初期処理完了イベント配信
			//生成元はこのイベントを取得して処理完了を知る。
			dispatchEvent(new Event(Modt005.MODT005COMPLETE));
		}

		//クリック時イベント
		//表示する画像の切り替えを行う
		function clickF(event:MouseEvent):void{
			image_arr[nowN].visible = false;
			nowN++;
			if(nowN > image_num - 1)nowN = 0;
			image_arr[nowN].visible = true;
			loading_text.text = text_arr[nowN];
		}
	}
}