﻿/*　概要ここから
クラス名：acs.ButtonMake
ボタン画像URL、ボタンロールオーバー時画像URL、クリック時表示URL、メニュー名称
上記四つを引数として受け取り、ボタンを作成する。
メニュー名称はボタン上にテキストとして表示する。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.net.navigateToURL;
	import flash.display.Loader;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;

	//MovieClipはEventDispatcherを継承しているためdispatchEvent使用可能
	public class ButtonMake extends MovieClip{

		//dispatchEventにて使用
		public static const BUTTONMAKECOMPLETE:String = "buttonmakecomplete";

		var image1_url:String;//ボタン画像URL
		var image2_url:String;//ボタンロールオーバー時画像URL
		var click_url:String;//クリック時の移動先URL
		var name_str:String;//メニューの名称
		var url_req:URLRequest;//xmlファイルロード用
		var imageLoader:Loader;//Loaderクラスインスタンス
		var imagedata_arr:Array = new Array();//ロード画像格納
		var image_num:int = 2;//ボタン画像数
		var image_cnt:int = 0;//ロード完了ボタン数
		var menuname_text : TextField = new TextField();//メニュー名称表示用

		//コンストラクタ
		//引数として受け取るのは以下の四つ
		//ボタン画像URL、ボタンロールオーバー時画像URL、
		//クリック時表示URL、メニュー名称
		function ButtonMake(url1:String , url2:String , url3:String , name:String){
			image1_url = url1;//ボタン画像URL
			image2_url = url2;//ボタンロールオーバー時画像URL
			click_url = url3;//クリック時表示URL取得
			name_str = name;//メニュー名称取得
		}

		//処理開始関数
		public function init():void{
			//ボタン画像ロード
			imageLoader = new Loader();
			url_req = new URLRequest(image1_url);
			imagedata_arr.push(imageLoader);
			imagedata_arr[0].contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoadF); 
			imagedata_arr[0].load(url_req);

			//ボタンロールオーバー時画像ロード
			imageLoader = new Loader();
			url_req = new URLRequest(image1_url);
			imagedata_arr.push(imageLoader);
			imagedata_arr[1].contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoadF); 
			imagedata_arr[1].load(url_req);
		}

		function imageLoadF(event:Event):void{
			image_cnt++;

			//画像を二つともロード完了
			if(image_cnt > image_num - 1){
				//ロールオーバー時画像を不可視にする
				imagedata_arr[1].visible = false;

				//マウスカーソルの形状変更
				this.buttonMode = true;

				//クリック、ロールオーバー、ロールアウト、マウスムーブイベント定義
				this.addEventListener(MouseEvent.CLICK , clickF);
				this.addEventListener(MouseEvent.ROLL_OVER , rollOverF);
				this.addEventListener(MouseEvent.ROLL_OUT , rollOutF);
				this.addEventListener(MouseEvent.MOUSE_MOVE , mouseMoveF);

				//表示ツリー構造に追加
				this.addChild(imagedata_arr[0]);
				this.addChild(imagedata_arr[1]);

				//テキストフィールドのフォーマット変更
				var format:TextFormat = new TextFormat();
				format.align = TextFieldAutoSize.LEFT;
				format.color = 0x000000;
				format.size = 16;
				menuname_text.defaultTextFormat = format;

				//メニューテキストサイズ変更及び表示(最初は不可視)
				//サイズは画像横幅にしています。
				menuname_text.width = this.getWidthF();
				menuname_text.text = name_str;
				menuname_text.visible = false;
				this.addChild(menuname_text);
				//初期処理完了イベント配信
				dispatchEvent(new Event(ButtonMake.BUTTONMAKECOMPLETE));
			}
		}

		//クリック時関数
		function clickF(event:MouseEvent):void{
			//ページ移動
			var temp_url:URLRequest = new URLRequest(click_url);
			navigateToURL(temp_url , "_blank");
		}

		//ロールオーバー時関数
		function rollOverF(event:MouseEvent):void{
			//ロールオーバー時画像と名称を可視
			imagedata_arr[1].visible = true;
			menuname_text.visible = true;
			event.updateAfterEvent();//表示更新
		}

		//ロールアウト時関数
		function rollOutF(event:MouseEvent):void{
			//ロールオーバー時画像と名称を不可視
			imagedata_arr[1].visible = false;
			menuname_text.visible = false;
			event.updateAfterEvent();//表示更新
		}

		//マウス移動時関数
		function mouseMoveF(event:MouseEvent):void{
			//メニュー名称をマウスカーソル右に表示
			menuname_text.x = mouseX + 20;
			menuname_text.y = mouseY;
			event.updateAfterEvent();//表示更新
		}

		//横幅を返す関数
		public function getWidthF():Number{
			if(imagedata_arr[1].width > imagedata_arr[0].width)return imagedata_arr[1].width;
			else return imagedata_arr[0].width;
		}
	}
}