﻿/*　概要ここから
クラス名：acs.Modt006
XMLファイルのurl(1個以上)を引数として受け取る
XmlLoadクラスを使用してXMLファイルのデータを取得後、ButtonMakeクラスにてボタンを作成する。
作成したボタンを横一列に並べる

ButtonMakeクラス及びXmlLoadクラスについては各asファイルを参照。
XmlLoadは配布サンプルmodt002に含まれるものと同様である。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.ButtonMake;
	import acs.XmlLoad;
	import flash.events.Event;
	import flash.display.MovieClip;

	//MovieClipはEventDispatcherを継承しているためdispatchEvent使用可能
	public class Modt006 extends MovieClip{

		//dispatchEventにて使用
		public static const MODT006COMPLETE:String = "modt006complete";	

		var xmlLoad:XmlLoad;//XmlLoadクラスインスタンス
		var buttonMake:ButtonMake;//ButtonMakeインスタンス
		var xml_num:int;//XMLファイル数
		var button_num:int = 0;//全ボタン数取得用
		var button_cnt:int = 0;//ボタン数カウント用
		var xmldata:XML;//XMLファイルのデータ格納
		var button_arr:Array = new Array();//ButtonMakeクラスインスタンス格納

		//コンストラクタ
		//配列として受け取っているのはXMLファイルのURL
		function Modt006(url_arr:Array){
			xml_num = url_arr.length;//XMLファイル数保存

			//XmlLoadクラスインスタンス生成
			xmlLoad = new XmlLoad(url_arr);
		}

		//処理開始関数
		public function init():void{
			//ロード完了イベントを設定
			xmlLoad.addEventListener(XmlLoad.LOADCOMPLETE,xmlLoadF);

			//処理開始
			xmlLoad.init();
		}

		//XML読み込み完了イベント取得時関数
		function xmlLoadF(event:Event):void{

			//全ボタン数取得
			for(var m:int = 0 ; m < xml_num ; m++){
				xmldata = xmlLoad.getDataF(m);
				for each(var xmldata:XML in xmldata.menudata){
					button_num++;
				}
			}

			//xmlデータを一つ目から順番に見ていく
			for(var i:int = 0 ; i < xml_num ; i++){
				//i番目のXMLファイルからデータを取得
				xmldata = xmlLoad.getDataF(i);

				//xmlデータの中から<menudata>～</menudata>を取得
				for each(var tempxml:XML in xmldata.menudata){

					//<menudata>～</menudata>内の各要素の取得
					//取得したデータを元にButtonMakeクラスインスタンス生成
					buttonMake = new ButtonMake(tempxml.imgurl1.toString() , tempxml.imgurl2.toString() , tempxml.clickurl.toString() , tempxml.name.toString());

					//ロード完了イベントを設定
					buttonMake.addEventListener(ButtonMake.BUTTONMAKECOMPLETE,buttonLoadF);

					//処理開始
					buttonMake.init();

					//配列に格納
					button_arr.push(buttonMake);
				}
			}
		}

		//ボタン生成初期処理完了イベント取得時関数
		function buttonLoadF(event:Event):void{
			button_cnt++;
			if(button_cnt > button_num - 1){

				//一つ目のボタンの位置調節
				button_arr[0].x = 0;
				this.addChild(button_arr[0]);

				//二つ目以降のボタン位置調節
				for(var i = 1 ; i < button_num ; i++){
					//前のボタンの右側に配置
					//getWidthF()はボタン幅取得用関数
					button_arr[i].x = button_arr[i-1].x + button_arr[i-1].getWidthF();

				}

				//ボタンを右側から順に表示リストに追加
				//カーソル右側のメニュー名が隠れないようにするため
				//左側のボタンほど前面に表示
				for(var m = button_num - 1 ; m > -1 ; m--){
					this.addChild(button_arr[m]);
				}

				//初期処理完了イベント配信
				//生成元はこのイベントを取得して処理完了を知る。
				dispatchEvent(new Event(Modt006.MODT006COMPLETE));
			}
		}
	}
}