﻿/*　概要ここから
クラス名：acs.ImageTable
引数として受け取ったURL配列を元にして、画像分だけLoaderNumクラスを生成する。
生成されたLoaderNumクラスを、引数の指定通りに並べる。
また、領域内に全画像を表示するための縮小率の保持も行う。
LoaderNumインスタンスをクリックした際は、
本クラスのインスタンスを仲介して生成元へクリックを通知する。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.LoaderNum;
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.geom.Point;
	import flash.text.TextField;

	public class ImageTable extends MovieClip{

		//dispatchEventにて使用
		public static const IMAGETABLECOMPLETE:String = "imagetablecomplete";
		public static const IMAGETABLECLICK:String = "imagetableclick";

		var imageurl_arr:Array = new Array();//画像URL格納
		var loaderNum:LoaderNum;//LoaderNumインスタンス
		var image_arr:Array = new Array();//LoaderNumインスタンス格納
		var image_num:int = 0;//全画像枚数
		var image_cnt:int = 0;//ロード完了画像枚数
		var area_width:int;//表示領域横幅
		var area_height:int;//表示領域縦幅
		var line_num:int;//一行(横)に並べる画像数
		var last_num:int;//最後にクリックした画像番号
		var image_point:Point;//Pointインスタンス
		var point_arr:Array = new Array();//各画像の座標を格納
		var small_scale:Number;//全画像表示時の%
		var loading_text:TextField = new TextField();//ロード状況表示用

		//コンストラクタ
		//w：表示領域横幅　h：表示領域縦幅
		//l：一行(横)に並べる画像数　url_arr：画像URL格納配列
		function ImageTable(w:int , h:int , l:int , url_arr:Array){
			imageurl_arr = url_arr;
			area_width = w;
			area_height = h;
			line_num = l;
			image_num = imageurl_arr.length;
		}

		//処理開始関数
		public function init():void{
			//テキストフィールドサイズ変更と表示
			loading_text.width = area_width;
			this.addChild(loading_text);

			//エンターフレームイベント生成
			this.addEventListener(Event.ENTER_FRAME , enterFrameF);

			//LoaderNumクラスインスタンス生成とイベント定義
			for(var i:int = 0 ; i < image_num ; i++){
				loaderNum = new LoaderNum(imageurl_arr[i] , i);
				loaderNum.addEventListener(LoaderNum.LOADERNUMCOMPLETE , imageLoadF);
				loaderNum.addEventListener(LoaderNum.LOADERNUMCLICK , imageClickF);
				loaderNum.init();
				image_arr.push(loaderNum);
			}
		}

		//画像読み込みの進度を表示するために使用
		//now Loading……　読込完了画像数　／　全画像数
		function enterFrameF(event:Event):void{
			loading_text.x = loading_text.y = 0;//左上に配置

			//テキストフィールド内容更新
			loading_text.text = "now Loading……  " + image_cnt + "　／　" + image_num; 
		}

		function imageLoadF(event:Event):void{
			image_cnt++;
			if(image_cnt > image_num - 1){
				//テキストフィールド表示終了
				this.removeChild(loading_text);
				for(var i:int = 0 ; i < image_num ; i++){
					//表示領域よりサイズが大きい場合に縮小
					if(image_arr[i].width > area_width || image_arr[i].height > area_height ){
						if(image_arr[i].width / area_width > image_arr[i].height / area_height){
							image_arr[i].height *= area_width / image_arr[i].width;
							image_arr[i].width = area_width;
						}
						else{
							image_arr[i].width *= area_height / image_arr[i].height;
							image_arr[i].height = area_height;
						}
					}	

					//位置を指定
					image_arr[i].x = area_width * (i % line_num);
					image_arr[i].y = area_height * Math.floor(i / line_num);

					//x座標とy座標の保持
					image_point = new Point(image_arr[i].x , image_arr[i].y);
					point_arr.push(image_point);

					//表示領域の中央に移動
					image_arr[i].x += (area_width - image_arr[i].width) / 2;
					image_arr[i].y += (area_height - image_arr[i].height) / 2;

					//表示ツリー構造に追加
					this.addChild(image_arr[i]);
				}

				//全画像を表示領域に納めるためのスケールを保持
				if(this.width / area_width > this.height / area_height)small_scale = area_width / this.width;
				else small_scale = area_height / this.height;

				//エンターフレームイベント削除
				this.removeEventListener(Event.ENTER_FRAME , enterFrameF);

				//マウスカーソルの形状変更
				this.buttonMode = true;

				//画像ロード完了を配信
				dispatchEvent(new Event(ImageTable.IMAGETABLECOMPLETE));
			}
		}

		//各画像クリック時関数
		function imageClickF(event:Event):void{
			//クリックした画像番号保持
			last_num = event.currentTarget.getNumF();
			//クリックを配信
			dispatchEvent(new Event(ImageTable.IMAGETABLECLICK));			
		}

		//全画像を表示領域に納めるためのスケールを返す
		public function getScaleF():Number{
			return small_scale;
		}

		//クリックした画像のxを返す
		public function getPointXF():Number{
			return point_arr[last_num].x;
		}

		//クリックした画像のyを返す
		public function getPointYF():Number{
			return point_arr[last_num].y;
		}
	}
}