﻿/*　概要ここから
クラス名：acs.Modt007
XMLファイルのurl(1個以上)を引数として受け取る
XmlLoadクラスを使用してXMLファイルのデータを取得後、
ImageTableクラスを使用して画像のロードと配置を行う。
画像のロード・配置完了後は、本クラス内にて画像の拡大縮小処理を行う。

ImageTableクラス及びXmlLoadクラスについては各asファイルを参照。
XmlLoadは配布サンプルmodt002に含まれるものと同様である。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.ImageTable;
	import acs.XmlLoad;
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.geom.Point;

	//MovieClipはEventDispatcherを継承しているためdispatchEvent使用可能
	public class Modt007 extends MovieClip{
		//dispatchEventにて使用
		public static const MODT007COMPLETE:String = "modt007complete";

		var xmlLoad:XmlLoad;//XmlLoadインスタンス用
		var imageTable:ImageTable;//ImageTableインスタンス用
		var area_width:int;//表示領域横幅
		var area_height:int;//表示領域縦幅
		var line_num:int;//一行の画像枚数
		var data_num:int;//ロードするXMLファイル数
		var next_point:Point = new Point(0 , 0);//目標座標
		var next_scale:Number = 1;//目標スケール
		var small_scale:Number;//最小時スケール
		var diff_num:Number = 0.5;//減速処理用変数

		//拡大中か縮小中かの判定
		//trueは拡大中(拡大完了)、flaseは縮小中(縮小完了)
		var zoom_boo:Boolean = true;

		//コンストラクタ
		//コンストラクタ
		//w：表示領域横幅　h：表示領域縦幅
		//l：一行(横)に並べる画像数　url_arr：XMLファイルURL格納配列
		function Modt007(w:int , h:int , l:int ,url_arr:Array){
			area_width = w;
			area_height = h;
			line_num = l;

			data_num = url_arr.length;//XMLファイル数保存

			xmlLoad = new XmlLoad(url_arr);//XmlLoadクラスインスタンス生成
		}

		//処理開始関数
		public function init():void{
			//ロード完了イベントを設定
			xmlLoad.addEventListener(XmlLoad.LOADCOMPLETE,xmlLoadF);

			//処理開始
			xmlLoad.init();
		}

		//XML読み込み完了イベント取得時関数
		function xmlLoadF(event:Event):void{
			var urldata_arr:Array = new Array();//url格納用
			var xmldata:XML;//xmlデータ格納用

			//xmlデータを一つ目から順番に見ていく
			for(var i:int = 0 ; i < data_num ; i++){
				//i番目のXMLデータを取得
				xmldata = xmlLoad.getDataF(i);

				//xmlデータの中から<url>～</url>を取得
				for each(var tempxml:XML in xmldata.url){
					urldata_arr.push(tempxml.toString());
				}
			}
			//ImageTableクラスインスタンス生成
			imageTable = new ImageTable(area_width , area_height , line_num , urldata_arr);

			//ImageTableクラス処理完了イベント登録
			imageTable.addEventListener(ImageTable.IMAGETABLECOMPLETE,imageLoadF);

			//処理開始
			imageTable.init();

			//imageTableクラスインスタンスを表示リストに追加
			this.addChild(imageTable);
		}

		//画像ロード完了
		function imageLoadF(event:Event):void{
			//縮小時スケール取得
			small_scale = imageTable.getScaleF();

			//エンターフレームイベント設定
			this.addEventListener(Event.ENTER_FRAME , enterFrameF);

			//imageTableクラスクリック時イベント登録
			imageTable.addEventListener(ImageTable.IMAGETABLECLICK,imageClickF);

			//初期処理完了イベント配信
			//生成元はこのイベントを取得して処理完了を知る。
			dispatchEvent(new Event(Modt007.MODT007COMPLETE));
		}

		//imageTableの座標を目標座標へと減速処理を行う
		//表示スケールについても同じように目標スケールへ近づける
		function enterFrameF(event:Event):void{
			imageTable.scaleX += (next_scale - imageTable.scaleX) * diff_num;
			imageTable.scaleY += (next_scale - imageTable.scaleY) * diff_num;
			imageTable.x += ( -1 * next_point.x - imageTable.x) * diff_num;
			imageTable.y += ( -1 * next_point.y - imageTable.y) * diff_num;
		}

		//クリックした状態によって拡大か縮小か分けている
		function imageClickF(event:Event):void{
			if(zoom_boo == true){
				zoom_boo = false;//縮小状態

				//目標座標設定
				next_point.x = next_point.y = 0;

				//縮小時スケールを目標に設定
				next_scale = small_scale;
			}
			else{
				zoom_boo = true;//拡大状態

				//クリックした画像の座標を目標とする
				next_point.x = imageTable.getPointXF();
				next_point.y = imageTable.getPointYF();

				//目標スケール設定
				next_scale = 1;
			}
		}
	
	}
}