﻿/*　概要ここから
クラス名：acs.LoaderNum
ロードする画像のurlと、int型の数値を引数として受け取る。
int型の数値は生成元が何番目の画像かを判断するためのものである。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.display.Loader;

	public class LoaderNum extends Loader{

		//dispatchEventにて使用
		public static const LOADERNUMCOMPLETE:String = "loadernumcomplete";
		public static const LOADERNUMCLICK:String = "loadernumclick";

		var image_url:String;//画像URL
		var my_num:int;//引数保持用

		//コンストラクタ
		function LoaderNum(temp_url:String , temp_num:int){
			image_url = temp_url;
			my_num = temp_num;//画像番号の保持
		}

		//処理開始関数
		public function init():void{
			//ロード完了イベント
			this.contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoadF);

			//画像ロード
			var url_req:URLRequest = new URLRequest(image_url);
			this.load(url_req);
		}

		//各画像ロード完了取得関数
		function imageLoadF(event:Event):void{
			//クリック時イベント
			this.addEventListener(MouseEvent.CLICK , clickF);

			//画像ロード完了を配信
			dispatchEvent(new Event(LoaderNum.LOADERNUMCOMPLETE));
		}

		//クリック時関数
		function clickF(event:MouseEvent):void{
			//クリックを配信
			dispatchEvent(new Event(LoaderNum.LOADERNUMCLICK));		
		}

		//番号取得用関数
		public function getNumF():int{
			return this.my_num;
		}
	}
}