﻿/*　概要ここから
クラス名：acs.Modt008
XMLファイルのurl(1個以上)を引数として受け取る
XmlLoadクラスを使用してXMLファイルのデータを取得後、
SetTableクラスとLoadTableクラスを使用して画像のロードと配置を行う。
SetTableクラスインスタンスは上部表示領域、LoadTableクラスインスタンスは下部表示領域(サムネイル)に使用。
各クラスについては各asファイルを参照。
XmlLoadは配布サンプルmodt002に含まれるものと同様である。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.SetTable;
	import acs.LoadTable;
	import acs.XmlLoad;
	import flash.events.Event;
	import flash.display.MovieClip;

	public class Modt008 extends MovieClip{
		//dispatchEventにて使用
		public static const MODT008COMPLETE:String = "modt008complete";

		var xmlLoad:XmlLoad;//XmlLoadインスタンス用
		var setTable:SetTable;//SetTableインスタンス用
		var loadTable:LoadTable;//LoadTableインスタンス用
		var area_width:int;//表示領域横幅
		var area_height:int;//上部表示領域縦幅
		var area_height2:int;//下部表示領域縦幅
		var line_num:int;//一行の画像枚数
		var data_num:int;//ロードするXMLファイル数
		var image_num:int = 0;//画像枚数
		var loadClass_cnt:int = 0;//二つのインスタンスの生成完了カウント

		//コンストラクタ
		//コンストラクタ
		//w：表示領域横幅　h：全表示領域縦幅　h2：下部表示領域縦幅
		//l：一行(横)に並べる画像数　url_arr：XMLファイルURL格納配列
		function Modt008(w:int , h:int , h2:int , l:int , url_arr:Array){

			area_width = w;
			area_height = h - h2;
			area_height2 = h2;
			line_num = l;
			data_num = url_arr.length;//XMLファイル数保存

			//XmlLoadクラスインスタンス生成
			xmlLoad = new XmlLoad(url_arr);
		}

		//処理開始関数
		public function init():void{
			//ロード完了イベントを設定
			xmlLoad.addEventListener(XmlLoad.LOADCOMPLETE , xmlLoadF);

			//処理開始
			xmlLoad.init();
		}

		//XML読み込み完了イベント取得時関数
		function xmlLoadF(event:Event):void{
			var urldata_arr:Array = new Array();//url格納用
			var xmldata:XML;//xmlデータ格納用

			//xmlデータを一つ目から順番に見ていく
			for(var i:int = 0 ; i < data_num ; i++){
				//i番目のXMLデータを取得
				xmldata = xmlLoad.getDataF(i);

				//xmlデータの中から<url>～</url>を取得
				for each(var tempxml:XML in xmldata.url){
					urldata_arr.push(tempxml.toString());
					image_num++;
				}
			}

			//SetTableクラスインスタンス生成
			setTable = new SetTable(area_width , area_height , line_num , urldata_arr);

			//LoadTableクラスインスタンス生成
			loadTable = new LoadTable(area_width , area_height , line_num , urldata_arr);

			//SetTableクラス処理完了イベント登録
			setTable.addEventListener(SetTable.SETTABLECOMPLETE , loadCompleteF);

			//LoadTableクラス処理完了イベント登録
			loadTable.addEventListener(LoadTable.LOADTABLECOMPLETE , loadCompleteF);

			//SetTableクラス処理開始
			setTable.init();

			//LoadTableクラス処理開始
			loadTable.init();

			//LoadTableクラスクリックイベント登録
			loadTable.addEventListener(LoadTable.LOADTABLECLICK , imageClickF);

			//LoadTableクラスインスタンスの位置とサイズ調整
			//下部表示領域内の中央にサムネイルが表示されるようにしている
			//下部表示領域に対しての横幅の比率が縦幅の比率より大きいかどうかで分岐
			loadTable.x = 0;
			loadTable.y = area_height;
			if(line_num > area_height * Math.ceil(image_num / line_num) / area_height2){
				loadTable.scaleX = loadTable.scaleY = 1 / line_num;
				loadTable.y += (area_height2 - area_height * Math.ceil(image_num / line_num) / line_num) / 2;
			}
			else{
				loadTable.scaleX = loadTable.scaleY =1 / (area_height * Math.ceil(image_num / line_num) / area_height2);
				loadTable.x += (area_width - area_width  * line_num / (area_height * Math.ceil(image_num / line_num) / area_height2)) / 2;
			}

			//SetTableクラスインスタンスを表示リストに追加
			this.addChild(setTable);

			//LoadTableクラスインスタンスを表示リストに追加
			this.addChild(loadTable);
		}

		//LoadTable及びSetTable処理完了
		function loadCompleteF(event:Event):void{
			loadClass_cnt++;
	
			//二つのクラスのインスタンスが処理完了
			if(loadClass_cnt > 1){
				//初期処理完了イベント配信
				//生成元はこのイベントを取得して処理完了を知る。
				dispatchEvent(new Event(Modt008.MODT008COMPLETE));
			}
		}

		//loadTableクラスのクリックを検知
		function imageClickF(event:Event):void{
			//クリックされた番号の取得と、クリックされた番号への画像移動
			setTable.moveTableF(loadTable.getNum());	
		}
	}
}