﻿/*　概要ここから
クラス名：acs.SetTable
引数として受け取ったURL配列を元にしてLoadTableクラスインスタンスを生成する。
生成したLoadTableクラスインスタンスにマスクをかける。
moveTableF関数によってLoadTableクラスインスタンスの移動を行う
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.LoadTable;
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.geom.Point;

	public class SetTable extends MovieClip{

		//dispatchEventにて使用
		public static const SETTABLECOMPLETE:String = "settablecomplete";

		var loadTable:LoadTable;//LoadTableクラスインスタンス
		var area_width:int;//表示領域横幅
		var area_height:int;//表示領域縦幅
		var diff_num:Number = 0.3;//減速処理用変数
		var next_point:Point = new Point(0 , 0);//目標座標

		//コンストラクタ
		//w：表示領域横幅　h：表示領域縦幅
		//l：一行(横)に並べる画像数　url_arr：画像URL格納配列
		function SetTable(w:int , h:int , l:int , url_arr:Array){
			area_width = w;
			area_height = h;
			//LoadTableクラスインスタンス生成
			loadTable = new LoadTable(w , h , l , url_arr);
		}

		//処理開始関数
		public function init():void{
			//LoadTableクラスインスタンス処理完了イベント登録
			loadTable.addEventListener(LoadTable.LOADTABLECOMPLETE,loadCompleteF);

			//LoadTableクラスインスタンス処理開始と表示
			loadTable.init()
			this.addChild(loadTable);

			//マスク用スプライト生成
			var mask_spr:Sprite = new Sprite();
			mask_spr.graphics.beginFill(0xFFFFF);
			mask_spr.graphics.drawRect(0 , 0 , area_width , area_height);
			mask_spr.graphics.endFill();
			this.addChild(mask_spr);

			//マスクをかける
			this.mask = mask_spr;
		}

		//LoadTableインスタンス処理完了
		function loadCompleteF(event:Event):void{
			//処理完了を配信
			dispatchEvent(new Event(SetTable.SETTABLECOMPLETE));
			//エンターフレームイベント生成
			this.addEventListener(Event.ENTER_FRAME , enterFrameF);
		}

		//画像移動依頼を受ける
		public function moveTableF(i:int):void{
			//クリックした画像の座標を目標とする
			next_point.x = loadTable.getPointXF(i);
			next_point.y = loadTable.getPointYF(i);
		}

		//画像の移動を行う
		function enterFrameF(event:Event):void{
			loadTable.x += ( -1 * next_point.x - loadTable.x) * diff_num;
			loadTable.y += ( -1 * next_point.y - loadTable.y) * diff_num;
		}
	}
}