﻿/*　概要ここから
クラス名：acs.LoadTable
引数として受け取ったURL配列を元にして、画像分だけLoaderNumクラスを生成する。
生成されたLoaderNumクラスを、縦横に並べる。
横に並べる数は引数で受け取る。
LoaderNumクラスはmodt007で使用しているものと同じである。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.LoaderNum;
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;

	public class LoadTable extends MovieClip{

		//dispatchEventにて使用
		public static const LOADTABLECOMPLETE:String = "loadtablecomplete";
		public static const LOADTABLECLICK:String = "loadtableclick";

		var imageurl_arr:Array = new Array();//画像URL格納
		var loaderNum:LoaderNum;//LoaderNumインスタンス
		var image_arr:Array = new Array();//ロード後画像格納
		var image_num:int = 0;//全画像枚数
		var image_cnt:int = 0;//ロード完了画像枚数
		var area_width:int;//表示領域横幅
		var area_height:int;//表示領域縦幅
		var line_num:int;//一行(横)に並べる画像数
		var last_num:int;//最後にクリックした画像番号
		var image_point:Point;//Pointインスタンス
		var point_arr:Array = new Array();//各画像の座標を格納
		var loading_text:TextField = new TextField();//ロード状況表示用

		//コンストラクタ
		//w：表示領域横幅　h：表示領域縦幅
		//l：一行(横)に並べる画像数　url_arr：画像URL格納配列
		function LoadTable(w:int , h:int , l:int , url_arr:Array){
			imageurl_arr = url_arr;
			area_width = w;
			area_height = h;
			line_num = l;
			image_num = imageurl_arr.length;
		}

		//処理開始関数
		public function init():void{
			//テキストフィールドサイズとフォーマット変更と表示
			loading_text.width = area_width;
			var format:TextFormat = new TextFormat();
			format.align = TextFieldAutoSize.LEFT;
			format.color = 0x888888;
			format.size = 40;
			loading_text.defaultTextFormat = format;
			this.addChild(loading_text);

			//エンターフレームイベント生成
			this.addEventListener(Event.ENTER_FRAME , enterFrameF);

			//各URL毎にLoaderNumインスタンスの生成
			for(var i:int = 0 ; i < image_num ; i++){
				loaderNum = new LoaderNum(imageurl_arr[i] , i);
				loaderNum.addEventListener(LoaderNum.LOADERNUMCOMPLETE , loadCompleteF);
				loaderNum.addEventListener(LoaderNum.LOADERNUMCLICK , imageClickF);
				loaderNum.init();
				image_arr.push(loaderNum);
			}
		}

		//画像読み込みの進度を表示するために使用
		//now Loading……　読込完了画像数　／　全画像数
		function enterFrameF(event:Event):void{
			loading_text.x = loading_text.y = 0;//左上に配置

			//テキストフィールド内容更新
			loading_text.text = "now Loading……  " + image_cnt + "　／　" + image_num; 
		}

		//LoaderNumクラスインスタンス処理完了時関数
		function loadCompleteF(event:Event):void{
			image_cnt++;

			//全LoaderNumインスタンス処理完了
			if(image_cnt > image_num - 1){
				//テキストフィールド表示終了
				this.removeChild(loading_text);
				for(var i:int = 0 ; i < image_num ; i++){
					//表示領域よりサイズが大きい場合に縮小
					if(image_arr[i].width > area_width || image_arr[i].height > area_height ){
						if(image_arr[i].width / area_width > image_arr[i].height / area_height){
							image_arr[i].height *= area_width / image_arr[i].width;
							image_arr[i].width = area_width;
						}
						else{
							image_arr[i].width *= area_height / image_arr[i].height;
							image_arr[i].height = area_height;
						}
					}	

					//位置を指定
					image_arr[i].x = area_width * (i % line_num);
					image_arr[i].y = area_height * Math.floor(i / line_num);

					//x座標とy座標の保持
					image_point = new Point(image_arr[i].x , image_arr[i].y);
					point_arr.push(image_point);

					//表示領域の中央に移動
					image_arr[i].x += (area_width - image_arr[i].width)/2;
					image_arr[i].y += (area_height - image_arr[i].height)/2;

					//表示ツリー構造に追加
					this.addChild(image_arr[i]);
				}

				//エンターフレームイベント削除
				this.removeEventListener(Event.ENTER_FRAME , enterFrameF);

				//マウスカーソルの形状変更
				this.buttonMode = true;

				//画像ロード完了を配信
				dispatchEvent(new Event(LoadTable.LOADTABLECOMPLETE));
			}
		}
		//各画像クリック時関数
		function imageClickF(event:Event):void{
			//クリックした画像番号保持
			last_num = event.currentTarget.getNumF();
			//クリックを配信
			dispatchEvent(new Event(LoadTable.LOADTABLECLICK));			
		}

		//クリックした画像の番号取得用
		public function getNum():int{
			return last_num;
		}

		//画像のx座標取得用　画像番号は引数にて指定
		public function getPointXF(i:int):int{
			return point_arr[i].x;
		}

		//画像のy座標取得用　画像番号は引数にて指定
		public function getPointYF(i:int):int{
			return point_arr[i].y;
		}
	}
}