﻿/*　概要ここから
クラス名：acs.LoadImages
引数として受け取ったURL配列を元にして、画像分だけLoaderNumクラスを生成する。
生成したLoaderNumクラスはすべて中央表示、不可視の状態とする。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.LoaderNum;
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.geom.Point;

	public class LoadImages extends MovieClip{

		//dispatchEventにて使用
		public static const LOADIMAGESCOMPLETE:String = "loadimagescomplete";
		public static const LOADIMAGESCLICK:String = "loadimagesclick";

		var imageurl_arr:Array = new Array();//画像URL格納
		var loaderNum:LoaderNum;//LoaderNumインスタンス
		var image_arr:Array = new Array();//ロード後画像格納
		var image_num:int = 0;//全画像枚数
		var image_cnt:int = 0;//ロード完了画像枚数
		var area_width:int;//表示領域横幅
		var area_height:int;//表示領域縦幅
		var last_num:int;//最後にクリックした画像番号

		//コンストラクタ
		//w：表示領域横幅　h：表示領域縦幅
		//url_arr：画像URL格納配列
		function LoadImages(w:int , h:int , url_arr:Array){
			imageurl_arr = url_arr;
			area_width = w;
			area_height = h;
			image_num = imageurl_arr.length;
		}

		//処理開始関数
		public function init():void{
			//各URL毎にLoaderNumインスタンスの生成
			for(var i:int = 0 ; i < image_num ; i++){
				loaderNum = new LoaderNum(imageurl_arr[i] , i);
				loaderNum.addEventListener(LoaderNum.LOADERNUMCOMPLETE , loadCompleteF);
				loaderNum.addEventListener(LoaderNum.LOADERNUMCLICK , imageClickF);
				loaderNum.init();
				image_arr.push(loaderNum);
			}
		}


		//LoaderNumクラスインスタンス処理完了時関数
		function loadCompleteF(event:Event):void{
			image_cnt++;

			//全LoaderNumインスタンス処理完了
			if(image_cnt > image_num - 1){
				for(var i:int = 0 ; i < image_num ; i++){
					//表示領域よりサイズが大きい場合に縮小
					if(image_arr[i].width > area_width || image_arr[i].height > area_height ){
						if(image_arr[i].width / area_width > image_arr[i].height / area_height){
							image_arr[i].height *= area_width / image_arr[i].width;
							image_arr[i].width = area_width;
						}
						else{
							image_arr[i].width *= area_height / image_arr[i].height;
							image_arr[i].height = area_height;
						}
					}	

					//表示領域の中央に移動
					image_arr[i].x += (area_width - image_arr[i].width)/2;
					image_arr[i].y += (area_height - image_arr[i].height)/2;

					//不可視にして表示ツリー構造に追加
					image_arr[i].visible = false;
					this.addChild(image_arr[i]);
				}

				//マウスカーソルの形状変更
				this.buttonMode = true;

				//画像ロード完了を配信
				dispatchEvent(new Event(LoadImages.LOADIMAGESCOMPLETE));
			}
		}

		//各画像クリック時関数
		function imageClickF(event:Event):void{
			//クリックした画像番号保持
			last_num = event.currentTarget.getNumF();
			//クリックを配信
			dispatchEvent(new Event(LoadImages.LOADIMAGESCLICK));			
		}

		//クリックした画像の番号取得用
		public function getNum():int{
			return last_num;
		}

		//i番目の画像の可視をjの状態にする
		public function setVisible(i:int , j:Boolean):void{
			image_arr[i].visible = j;
		}
	}
}