﻿/*　概要ここから
クラス名：acs.Modt009
XMLファイルのurl(1個以上)を引数として受け取る
XmlLoadクラスを使用してXMLファイルのデータを取得後、
LoadImagesクラスとLoadTableクラスを使用して画像のロードと配置を行う。
LoadTableクラスインスタンスはサムネイル表示に使用、LoadImagesクラスインスタンスは通常表示に使用している。
LoadTableクラスはmodt008に含まれるものと同様であるが、「point_arr:Array」「getPointXF」「getPointYF」については本プログラムでは使用していない。
各クラスについて詳しくは各asファイルを参照。
XmlLoadは配布サンプルmodt002に含まれるものと同様である。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.LoadImages;
	import acs.LoadTable;
	import acs.XmlLoad;
	import flash.events.Event;
	import flash.display.MovieClip;

	public class Modt009 extends MovieClip{
		//dispatchEventにて使用
		public static const MODT009COMPLETE:String = "modt009complete";

		var xmlLoad:XmlLoad;//XmlLoadインスタンス用
		var loadTable:LoadTable;//LoadTableインスタンス用
		var loadImages:LoadImages;//LoadImagesインスタンス用
		var area_width:int;//表示領域横幅
		var area_height:int;//表示領域縦幅
		var line_num:int;//一行の画像枚数
		var data_num:int;//ロードするXMLファイル数
		var image_num:int = 0;//画像枚数
		var loadClass_cnt:int = 0;//二つのインスタンスの生成完了カウント
		var now_num:int = 0;//現在表示する画像番号

		//コンストラクタ
		//w：表示領域横幅　h：表示領域縦幅
		//l：一行(横)に並べる画像数　url_arr：XMLファイルURL格納配列
		function Modt009(w:int , h:int , l:int , url_arr:Array){

			area_width = w;
			area_height = h;
			line_num = l;
			data_num = url_arr.length;//XMLファイル数保存

			//XmlLoadクラスインスタンス生成
			xmlLoad = new XmlLoad(url_arr);
		}

		//処理開始関数
		public function init():void{
			//ロード完了イベントを設定
			xmlLoad.addEventListener(XmlLoad.LOADCOMPLETE , xmlLoadF);

			//処理開始
			xmlLoad.init();
		}


		//XML読み込み完了イベント取得時関数
		function xmlLoadF(event:Event):void{
			var urldata_arr:Array = new Array();//url格納用
			var xmldata:XML;//xmlデータ格納用

			//xmlデータを一つ目から順番に見ていく
			for(var i:int = 0 ; i < data_num ; i++){
				//i番目のXMLデータを取得
				xmldata = xmlLoad.getDataF(i);

				//xmlデータの中から<url>～</url>を取得
				for each(var tempxml:XML in xmldata.url){
					urldata_arr.push(tempxml.toString());
					image_num++;
				}
			}


			//LoadImagesクラスインスタンス生成
			loadImages = new LoadImages(area_width , area_height , urldata_arr);

			//LoadTableクラスインスタンス生成
			loadTable = new LoadTable(area_width , area_height , line_num , urldata_arr);

			//LoadImagesクラス処理完了イベント登録
			loadImages.addEventListener(LoadImages.LOADIMAGESCOMPLETE , loadCompleteF);

			//LoadTableクラス処理完了イベント登録
			loadTable.addEventListener(LoadTable.LOADTABLECOMPLETE , loadCompleteF);

			//LoadImagesクラスインスタンス処理開始
			loadImages.init();

			//LoadTableクラスインスタンス処理開始
			loadTable.init();

			//LoadTableクラスインスタンスの位置とサイズ調整
			//下部表示領域内の中央にサムネイルが表示されるようにしている
			//下部表示領域に対しての横幅の比率が縦幅の比率より大きいかどうかで分岐
			loadTable.x = loadTable.y = 0;
			if(line_num > Math.ceil(image_num / line_num)){
				loadTable.scaleX = loadTable.scaleY = 1 / line_num;
				loadTable.y += (area_height - area_height * Math.ceil(image_num / line_num) / line_num) / 2;
			}
			else{
				loadTable.scaleX = loadTable.scaleY =1 / (Math.ceil(image_num / line_num));
				loadTable.x += (area_width - area_width  * line_num / (Math.ceil(image_num / line_num))) / 2;
			}

			//クラスインスタンスを表示リストに追加
			this.addChild(loadTable);
			this.addChild(loadImages);
		}

		//LoadTable及びLoadImages処理完了
		function loadCompleteF(event:Event):void{
			loadClass_cnt++;
	
			//二つのクラスのインスタンスが処理完了
			if(loadClass_cnt > 1){
				//LoadImagesクラスクリックイベント登録
				loadImages.addEventListener(LoadImages.LOADIMAGESCLICK , click2F);

				//LoadTableクラスクリックイベント登録
				loadTable.addEventListener(LoadTable.LOADTABLECLICK , click1F);

				//初期処理完了イベント配信
				//生成元はこのイベントを取得して処理完了を知る。
				dispatchEvent(new Event(Modt009.MODT009COMPLETE));
			}
		}

		//LoadTableクラスのクリックを検知
		function click1F(event:Event):void{
			//前の画像を不可視、今の画像を可視にする
			loadImages.setVisible(now_num ,  false);
			now_num = loadTable.getNum();
			loadImages.setVisible(now_num ,  true);
		}

		//LoadImagesクラスのクリックを検知
		function click2F(event:Event):void{
			//画像を不可視にする
			loadImages.setVisible(now_num ,  false);
		}
	}
}