﻿/*　概要ここから
クラス名：acs.XmlLoad
コンストラクタにて引数として受け取ったURL格納配列を元にXMLファイルをロードする。
public function getDataFにて指定された番号(0～)のXMLデータをreturnする。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import flash.net.URLLoader;
	import flash.net.URLLoaderDataFormat;
	import flash.net.URLRequest;
	import flash.system.System
	import flash.events.Event;
	import flash.events.EventDispatcher;

	//dispatchEventのためにEventDispatcherを継承
	public class XmlLoad extends EventDispatcher{

		//dispatchEventにて使用
		public static const LOADCOMPLETE:String = "loadcomplete";

		var url_arr:Array = new Array();//XMLファイルのURL格納
		var urlload_arr:Array = new Array();//URLLoader()インスタンス格納
		var xmldata_arr:Array = new Array();//XMLのデータ格納
		var data_num:int;//ロードするXMLファイル数
		var data_cnt:int = 0;//ロード完了XMLファイル数計算

		//コンストラクタ
		//引数として受け取るのはxmlファイルのURLを格納した文字列配列
		function XmlLoad(string_arr:Array){
			url_arr = string_arr;
			System.useCodePage = true;//文字コードがunicodeの場合は不要
			data_num = url_arr.length;//xmlファイル数保存
		}

		//処理開始関数
		public function init():void{
			var url_load:URLLoader;//xmlファイルロード用
			var url_req:URLRequest;//xmlファイルロード用

			for(var i:int = 0 ; i<data_num ; i++){
				//生成したURLLoaderインスタンスを配列最後尾に追加
				url_load = new URLLoader();
				urlload_arr.push(url_load);

				//データ受信方法決定(テキストデータでの受信)
				urlload_arr[i].dataFormat = URLLoaderDataFormat.TEXT;
	
				//ロード完了イベント設定
				urlload_arr[i].addEventListener(Event.COMPLETE , loadF);

				//URLを定義してロード開始
				url_req = new URLRequest(url_arr[i]);
				urlload_arr[i].load(url_req);
			}
		}

		//ロード完了時関数
		function loadF(event:Event):void{
			//何番目(0～)のURLによるロードかを取得
			var temp:int = urlload_arr.indexOf(event.currentTarget);

			//ロードしたXMLのデータを配列に格納
			xmldata_arr[temp] = new XML(event.currentTarget.data);

			//ロード完了数を増やす
			data_cnt++;

			//全ロードを完了した際、イベントをブロードキャスト
			//本クラスを利用する側はこのイベントを取得してロード完了を知る
			if(data_cnt > data_num - 1)
				dispatchEvent(new Event(XmlLoad.LOADCOMPLETE));	
		}

		//xmlデータ取得用関数
		//引数として受け取った数が示す番号(0～)のXMLデータを返す
		public function getDataF(i:int):XML{
			return xmldata_arr[i];
		}
	}
}