﻿/*　概要ここから
クラス名：acs.ZoomTable
引数として受け取ったURL配列を元にして、画像分だけLoaderNumクラスを生成する。
生成されたLoaderNumクラスを、縦横に並べる。
横に並べる数は引数で受け取る。

各画像の深度は以下の式で求めています(同じ深度が現れないようにしています)
現在のスケールの整数値×画像枚数 ＋ 画像番号

LoaderNumクラスはmodt007で使用しているものと同じである。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.LoaderNum;
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;

	public class ZoomTable extends MovieClip{

		//dispatchEventにて使用
		public static const ZOOMTABLECOMPLETE:String = "zoomtablecomplete";

		var imageurl_arr:Array = new Array();//画像URL格納
		var loaderNum:LoaderNum;//LoaderNumインスタンス
		var image_arr:Array = new Array();//ロード後画像格納
		var image_num:int = 0;//全画像枚数
		var image_cnt:int = 0;//ロード完了画像枚数
		var area_width:int;//画像一枚表示する横幅
		var area_height:int;//画像一枚表示する縦幅
		var line_num:int;//一行(横)に並べる画像数
		var last_num:int = 0;//最後にクリックした画像番号
		var largeScale_arr:Array = new Array();//拡大表示する際の画像スケール
		var defaultScale_arr:Array = new Array();//通常表示の際の画像スケール
		var diff_num:Number = 0.3;//減速処理用変数
		var max_depth:int;//最大深度
		var image_point:Point;//Pointインスタンス
		var point_arr:Array = new Array();//各画像の通常時座標を格納
		var point_arr2:Array = new Array();//各画像の拡大時座標を格納
		var zoom_arr:Array = new Array();//各画像が拡大中か縮小中か取得
		var loading_text:TextField = new TextField();//ロード状況表示用
		var other_num:int;//linkButton以外のインスタンス数

		//コンストラクタ
		//w：表示領域横幅　h：表示領域縦幅
		//l：一行(横)に並べる画像数　url_arr：画像URL格納配列
		function ZoomTable(w:int , h:int , l:int , url_arr:Array){
			imageurl_arr = url_arr;
			area_width = w;
			area_height = h;
			line_num = l;
			image_num = imageurl_arr.length;
		}

		//処理開始関数
		public function init():void{
			//テキストフィールドサイズとフォーマット変更と表示
			loading_text.width = area_width;
			var format:TextFormat = new TextFormat();
			format.align = TextFieldAutoSize.LEFT;
			format.color = 0x888888;
			format.size = 40;
			loading_text.defaultTextFormat = format;
			this.addChild(loading_text);

			//ロード状況表示用エンターフレームイベント生成
			this.addEventListener(Event.ENTER_FRAME , enterFrameF);

			//各URL毎にLoaderNumインスタンスの生成
			for(var i:int = 0 ; i < image_num ; i++){
				loaderNum = new LoaderNum(imageurl_arr[i] , i);
				loaderNum.addEventListener(LoaderNum.LOADERNUMCOMPLETE , loadCompleteF);
				loaderNum.addEventListener(LoaderNum.LOADERNUMCLICK , imageClickF);
				loaderNum.init();
				image_arr.push(loaderNum);
				zoom_arr[i] = false;//値を縮小中にセットする
			}
		}

		//画像読み込みの進度を表示するために使用
		//now Loading……　読込完了画像数　／　全画像数
		function enterFrameF(event:Event):void{
			loading_text.x = loading_text.y = 0;//左上に配置

			//テキストフィールド内容更新
			loading_text.text = "now Loading……  " + image_cnt + "　／　" + image_num; 
		}

		//LoaderNumクラスインスタンス処理完了時関数
		function loadCompleteF(event:Event):void{
			image_cnt++;

			//全LoaderNumインスタンス処理完了
			if(image_cnt > image_num - 1){

				//縦の画像数
				var line_num2 = Math.ceil(image_num / line_num);

				var large_scale:int;//拡大表示の際の倍率

				//large_scaleを求める
				if(line_num > line_num2)large_scale = line_num;
				else large_scale =line_num2;

				//テキストフィールド表示終了
				this.removeChild(loading_text);

				for(var i:int = 0 ; i < image_num ; i++){

					//通常表示倍率に1を設定
					defaultScale_arr[i] = 1;

					//表示領域よりサイズが大きい場合に縮小
					if(image_arr[i].width > area_width || image_arr[i].height > area_height ){
						if(image_arr[i].width / area_width > image_arr[i].height / area_height){
							image_arr[i].height *= area_width / image_arr[i].width;
							image_arr[i].width = area_width;
						}
						else{
							image_arr[i].width *= area_height / image_arr[i].height;
							image_arr[i].height = area_height;
						}
						defaultScale_arr[i] = image_arr[i].scaleX;//通常表示倍率設定
					}	

					largeScale_arr[i] = defaultScale_arr[i] * large_scale;//拡大表示倍率を設定

					//位置を指定　各区画内の左上となる
					image_arr[i].x = area_width * (i % line_num);
					image_arr[i].y = area_height * Math.floor(i / line_num);

					//区画の中央に移動
					image_arr[i].x += (area_width - image_arr[i].width)/2;
					image_arr[i].y += (area_height - image_arr[i].height)/2;

					//通常表示時のx座標とy座標の保持
					image_point = new Point(image_arr[i].x , image_arr[i].y);
					point_arr.push(image_point);

					//拡大表示時のx座標とy座標の保持
					image_point = new Point((line_num * area_width - largeScale_arr[i] * image_arr[i].width) / 2 , (line_num2 * area_height - largeScale_arr[i] * image_arr[i].height) / 2);
					point_arr2.push(image_point);

					//表示ツリー構造に追加
					this.addChild(image_arr[i]);
				}

				//LoaderNumクラスインスタンス以外の表示インスタンス数計算
				other_num = this.numChildren - image_num;

				//最大深度を求める
				//実際にはこの値マイナス1までしか使っていない
				max_depth = large_scale * image_num + image_num + other_num;

				//深度変更のために空のムービークリップを表示リストに追加
				for(var m:int = image_num + other_num ; m < max_depth ; m++){
					var mc:MovieClip = new MovieClip();
					this.addChild(mc);
				}

				//ロード状況表示用エンターフレームイベント削除
				this.removeEventListener(Event.ENTER_FRAME , enterFrameF);

				//画像移動用エンターフレームイベント生成
				this.addEventListener(Event.ENTER_FRAME , enterFrame2F);

				//マウスカーソルの形状変更
				this.buttonMode = true;

				//画像ロード完了を配信
				dispatchEvent(new Event(ZoomTable.ZOOMTABLECOMPLETE));
			}
		}

		//各画像クリック時関数
		function imageClickF(event:Event):void{
			//現在拡大中の画像をクリックした場合
			if(last_num == event.currentTarget.getNumF() && zoom_arr[last_num] == true){
				zoom_arr[last_num] = false;
				return;
			}

			//前にクリックした画像を縮小
			zoom_arr[last_num] = false;

			//クリックした画像番号保持
			last_num = event.currentTarget.getNumF();
			//今クリックした画像を拡大
			zoom_arr[last_num] = true;
		}

		//画像拡大縮小処理用エンターフレームイベント
		function enterFrame2F(event:Event):void{
			for(var i:int = 0 ; i < image_num ; i++){
				//拡大と縮小によって分岐している
				if(zoom_arr[i] == true){
					image_arr[i].x += (point_arr2[i].x - image_arr[i].x) * diff_num;
					image_arr[i].y += (point_arr2[i].y - image_arr[i].y) * diff_num; 
					image_arr[i].scaleX += (largeScale_arr[i] - image_arr[i].scaleX)  * diff_num;
					image_arr[i].scaleY = image_arr[i].scaleX;
				}
				else {
					image_arr[i].x += (point_arr[i].x - image_arr[i].x) * diff_num;
					image_arr[i].y += (point_arr[i].y - image_arr[i].y) * diff_num; 
					image_arr[i].scaleX += ( defaultScale_arr[i] - image_arr[i].scaleX)  * diff_num;
					image_arr[i].scaleY = image_arr[i].scaleX;
				}
				//現在のスケール(通常表示を1と考えたスケール)を元にして深度変更
				//scaleX を -0.1にしているのは縮小表示している画像を確実に背面にするため
				this.setChildIndex(image_arr[i] , image_num * Math.ceil(image_arr[i].scaleX / defaultScale_arr[i] - 0.1) + i + other_num);
			}
		}
	}
}