﻿/*　概要ここから
クラス名：acs.Modt010
XMLファイルのurl(1個以上)を引数として受け取る
XmlLoadクラスを使用してXMLファイルのデータを取得後、
ZoomTableクラスを使用して画像のロードと配置を行う。
また、ZoomTableクラスは拡大と縮小の処理も行う
XmlLoadは配布サンプルmodt002に含まれるものと同様である。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.ZoomTable;
	import acs.XmlLoad;
	import flash.events.Event;
	import flash.display.MovieClip;

	public class Modt010 extends MovieClip{
		//dispatchEventにて使用
		public static const MODT010COMPLETE:String = "modt010complete";

		var xmlLoad:XmlLoad;//XmlLoadインスタンス用
		var zoomTable:ZoomTable;//ZoomTableインスタンス用
		var area_width:int;//表示領域横幅
		var area_height:int;//表示領域縦幅
		var line_num:int;//一行の画像枚数
		var data_num:int;//ロードするXMLファイル数
		var image_num:int = 0;//画像枚数

		//コンストラクタ
		//w：表示領域横幅　h：表示領域縦幅
		//l：一行(横)に並べる画像数　url_arr：XMLファイルURL格納配列
		function Modt010(w:int , h:int , l:int , url_arr:Array){

			area_width = w;
			area_height = h;
			line_num = l;
			data_num = url_arr.length;//XMLファイル数保存

			//XmlLoadクラスインスタンス生成
			xmlLoad = new XmlLoad(url_arr);
		}

		//処理開始関数
		public function init():void{
			//ロード完了イベントを設定
			xmlLoad.addEventListener(XmlLoad.LOADCOMPLETE , xmlLoadF);

			//処理開始
			xmlLoad.init();
		}

		//XML読み込み完了イベント取得時関数
		function xmlLoadF(event:Event):void{
			var urldata_arr:Array = new Array();//url格納用
			var xmldata:XML;//xmlデータ格納用

			//xmlデータを一つ目から順番に見ていく
			for(var i:int = 0 ; i < data_num ; i++){
				//i番目のXMLデータを取得
				xmldata = xmlLoad.getDataF(i);

				//xmlデータの中から<url>～</url>を取得
				for each(var tempxml:XML in xmldata.url){
					urldata_arr.push(tempxml.toString());
					image_num++;
				}
			}

			//ZoomTableクラスインスタンス生成
			zoomTable = new ZoomTable(area_width , area_height , line_num , urldata_arr);

			//ZoomTableクラス処理完了イベント登録
			zoomTable.addEventListener(ZoomTable.ZOOMTABLECOMPLETE , loadCompleteF);

			//ZoomTableクラス処理開始
			zoomTable.init();

			//ZoomTableクラスインスタンスの位置とサイズ調整
			//下部表示領域内の中央にサムネイルが表示されるようにしている
			//下部表示領域に対しての横幅の比率が縦幅の比率より大きいかどうかで分岐
			zoomTable.x = zoomTable.y = 0;
			if(line_num > Math.ceil(image_num / line_num)){
				zoomTable.scaleX = zoomTable.scaleY = 1 / line_num;
				zoomTable.y += (area_height - area_height * Math.ceil(image_num / line_num) / line_num) / 2;
			}
			else{
				zoomTable.scaleX = zoomTable.scaleY =1 / (Math.ceil(image_num / line_num));
				zoomTable.x += (area_width - area_width  * line_num / (Math.ceil(image_num / line_num))) / 2;
			}

			//クラスインスタンスを表示リストに追加
			this.addChild(zoomTable);
		}

		//ZoomTable処理完了
		function loadCompleteF(event:Event):void{
			//初期処理完了イベント配信
			//生成元はこのイベントを取得して処理完了を知る。
			dispatchEvent(new Event(Modt010.MODT010COMPLETE));
		}
	}
}