﻿/*　概要ここから
クラス名：acs.LinkButton
受け取ったURLを元にリンクのボタンを生成する。
ボタンは基準点から受け取った引数の値に従い、y座標の負の方向に離す。
生成元が何番目の画像かを判断するための引数を持つ。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.MovieClip;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.net.navigateToURL;

	public class LinkButton extends MovieClip{

		//dispatchEventにて使用
		public static const LINKBUTTONCOMPLETE:String = "linkbuttoncomplete";
		public static const LINKBUTTONROLLOVER:String = "linkbuttonrollover";
		public static const LINKBUTTONROLLOUT:String = "linkbuttonrollout";

		var image_url:String;//ボタン画像URL
		var link_url:String;//クリック時移動ページURL
		var num_int:int;//番号
		var indent_int:int;//基準点からの距離
		var imageLoader:Loader;//Loaderクラスインスタンス
		var url_req:URLRequest;

		//コンストラクタ
		//url1：ボタン画像URL　url2：クリック時移動ページURL
		//num：ボタン番号　indent:中心からの距離
		function LinkButton(url1:String , url2:String , num:int , indent:int){
			image_url = url1;
			link_url = url2;
			num_int = num;
			indent_int = indent;
		}

		//処理開始関数
		public function init():void{
			//画像のロード
			imageLoader = new Loader();
			imageLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoadF); 
			url_req = new URLRequest(image_url);
			imageLoader.load(url_req);
		}

		//画像ロード完了時関数
		function imageLoadF(event:Event):void{
			//クリック、ロールオーバー、ロールアウトイベント定義
			imageLoader.addEventListener(MouseEvent.CLICK , clickF);
			imageLoader.addEventListener(MouseEvent.ROLL_OVER , rollOverF);
			imageLoader.addEventListener(MouseEvent.ROLL_OUT , rollOutF);

			//マウスカーソルの形状変更
			this.buttonMode = true;

			//基準点からy座標負の方向indent_intの位置に画像の中心が来るように変更
			imageLoader.x -= imageLoader.width / 2;
			imageLoader.y -= indent_int + imageLoader.height / 2;

			//画像表示
			this.addChild(imageLoader);

			//初期処理完了を配信
			dispatchEvent(new Event(LinkButton.LINKBUTTONCOMPLETE));
		}

		//クリック時関数
		function clickF(event:MouseEvent):void{
			//ページ移動
			url_req = new URLRequest(link_url);
			navigateToURL(url_req , "_blank");
		}

		//ロールオーバー時関数
		function rollOverF(event:MouseEvent):void{
			//イベント配信
			dispatchEvent(new Event(LinkButton.LINKBUTTONROLLOVER));
		}

		//ロールアウト時関数
		function rollOutF(event:MouseEvent):void{
			//イベント配信
			dispatchEvent(new Event(LinkButton.LINKBUTTONROLLOUT));
		}

		//番号取得用関数
		public function getNumF():int{
			return num_int;
		}
	}
}