﻿/*　概要ここから
クラス名：acs.Modt011

LinkButtonクラスをXMLファイル内の<linkdata>タグ数分だけ作成し、円状に配置する。
ロールオーバー時にはそのリンク上に集まり、ロールアウト時には円状に戻る。
また、ロールオーバー時には説明文が中央に表示される。

XmlLoadは配布サンプルmodt002に含まれるものと同様である。
概要ここまで　*/

package acs{
	//必要なpackageのimport
	import acs.LinkButton;
	import acs.XmlLoad;
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.text.Font;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;

	public class Modt011 extends MovieClip{
		//dispatchEventにて使用
		public static const MODT011COMPLETE:String = "modt011complete";

		var xmlLoad:XmlLoad;//XmlLoadインスタンス用
		var linkButton_arr:Array = new Array();//LinkButtonインスタンス格納用
		var area_width:int;//表示領域横幅
		var area_height:int;//表示領域縦幅
		var data_num:int;//ロードするXMLファイル数
		var linkbutton_num:int = 0;//全リンク数
		var linkbutton_cnt:int = 0;//リンク数カウント用
		var linkangle_arr:Array = new Array();//角度格納
		var nextangle_arr:Array = new Array();//目標角度格納
		var review_arr:Array = new Array();//説明文格納用
		var deg_int:int = 20;//1フレームでの回転度数
		var now_int:int = 1;//時計回り中なら1、反時計回り中は0
		var indent_int:int = 300;//中心からの距離
		var review_text:TextField = new TextField();//説明文表示用
		var other_num:int;//linkButton以外のインスタンス数

		//コンストラクタ
		//w：表示領域横幅　h：表示領域縦幅　url_arr：XMLファイルURL格納配列
		function Modt011(w:int , h:int , url_arr:Array){

			data_num = url_arr.length;//XMLファイル数保存
			area_width = w;
			area_height = h;

			//XmlLoadクラスインスタンス生成
			xmlLoad = new XmlLoad(url_arr);
		}

		//処理開始関数
		public function init():void{
			//ロード完了イベントを設定
			xmlLoad.addEventListener(XmlLoad.LOADCOMPLETE , xmlLoadF);

			//処理開始
			xmlLoad.init();

			//ロード状況表示用テキストフィールドのフォーマット変更
			var format:TextFormat = new TextFormat();
			format.align = TextFieldAutoSize.CENTER;
			format.color = 0x888888;
			format.size = 18;
			review_text.selectable = false;
			review_text.defaultTextFormat = format;
			review_text.width = area_width;
			review_text.y = area_height / 2 + review_text.textHeight / 2;
			review_text.x = 0
			this.addChild(review_text);

			//ロード状況表示用エンターフレームイベント
			this.addEventListener(Event.ENTER_FRAME , enterFrameF);
		}

		//XML読み込み完了イベント取得時関数
		function xmlLoadF(event:Event):void{
			var xmldata:XML;//xmlデータ格納用
			var linkButton:LinkButton;//LinkButtonインスタンス用
			var temp_cnt:int = 0;//ロード開始数カウント用

			//全リンク数取得
			//xmlデータを一つ目から順番に見ていく
			for(var i:int = 0 ; i < data_num ; i++){
				//i番目のXMLデータを取得
				xmldata = xmlLoad.getDataF(i);
				//xmlデータの中から<linkdata>～</linkdata>を取得
				for each(var temp:XML in xmldata.linkdata){
					linkbutton_num++;
				}
			}

			//xmlデータを一つ目から順番に見ていく
			for(var j:int = 0 ; j < data_num ; j++){
				//j番目のXMLデータを取得
				xmldata = xmlLoad.getDataF(j);

				//xmlデータの中から<linkdata>～</linkdata>を取得
				for each(var tempxml:XML in xmldata.linkdata){

					//LinkButtonクラスインスタンス生成
					linkButton = new LinkButton(tempxml.url1.toString() , tempxml.url2.toString() , temp_cnt , indent_int);
					linkButton.addEventListener(LinkButton.LINKBUTTONCOMPLETE , completeF);
					linkButton.init();
					linkButton_arr.push(linkButton);

					//イベント設定
					linkButton_arr[temp_cnt].addEventListener(LinkButton.LINKBUTTONROLLOVER , rollOverF);
					linkButton_arr[temp_cnt].addEventListener(LinkButton.LINKBUTTONROLLOUT , rollOutF);

					//説明文保管
					review_arr.push(tempxml.review.toString());
					temp_cnt++;
				}
			}
		}

		//ロード状況表示用エンターフレーム
		function enterFrameF(event:Event):void{
			review_text.text = "now_loading" + linkbutton_cnt + "　／　" + linkbutton_num;
		}

		//LinkButtonインスタンス生成完了
		function completeF(event:Event):void{
			linkbutton_cnt++;

			//全ボタンロード完了
			if(linkbutton_cnt > linkbutton_num - 1){

				//リンクボタンの角度や位置調整等
				for(var i:int = 0 ; i < linkbutton_num ; i++){

					//角度設定
					linkangle_arr[i] = (360.0 / linkbutton_num) * i;
					nextangle_arr[i] = linkangle_arr[i];

					//基準点を中心に移動する
					linkButton_arr[i].x = area_width / 2;
					linkButton_arr[i].y = area_height / 2;

					//LinkButtonインスタンスを表示
					this.addChild(linkButton_arr[i]);
				}

				//ロード状況表示終了
				this.removeEventListener(Event.ENTER_FRAME , enterFrameF);
				review_text.text = "";

				//LinkButtonインスタンス以外の表示インスタンス数計算
				other_num = this.numChildren - linkbutton_num;

				//リンク回転用エンターフレームイベント
				this.addEventListener(Event.ENTER_FRAME , enterFrameF2);

				//初期処理完了イベント配信
				//生成元はこのイベントを取得して処理完了を知る。
				dispatchEvent(new Event(Modt011.MODT011COMPLETE));
			}
		}

		//エンターフレームイベント
		//リンクの回転を行う
		function enterFrameF2(event:Event):void{

			//ロールオーバー時は反時計回り、ロールアウト時は時計回り
			//現在の角度と目標の角度によって処理をさらに分岐
			if(now_int == 1){
				for(var i:int = 0 ; i < linkbutton_num ; i++){
					var temp:Number = ((linkButton_arr[i].rotation + 360) % 360);//計算用一時変数
					if(temp > nextangle_arr[i]){
						if(temp + deg_int > 360 && temp + deg_int - 360 > nextangle_arr[i])linkButton_arr[i].rotation = nextangle_arr[i];
						else linkButton_arr[i].rotation += deg_int;
					}
					else{
						if(temp + deg_int > nextangle_arr[i])linkButton_arr[i].rotation = nextangle_arr[i];
						else linkButton_arr[i].rotation += deg_int;
					}
				}
			}
			else if(now_int == 0){
				for(var j:int = 0 ; j < linkbutton_num ; j++){
					var temp2:Number = ((linkButton_arr[j].rotation + 360) % 360);//計算用一時変数
					if(temp2 < nextangle_arr[j]){
						if(temp2 - deg_int < 0 && temp2 - deg_int + 360 < nextangle_arr[j])linkButton_arr[j].rotation = nextangle_arr[j];
						else linkButton_arr[j].rotation -= deg_int;
					}
					else{
						if(temp2 - deg_int < nextangle_arr[j])linkButton_arr[j].rotation = nextangle_arr[j];
						else linkButton_arr[j].rotation -= deg_int;
					}
				}
			}
		}

		//ロールオーバーイベント
		//ロールオーバー中のリンク上に他のリンクが重なるように目標角度調整
		function rollOverF(event:Event):void{

			//クリックしたボタンの番号
			var temp = event.currentTarget.getNumF();

			//角度を計算用に0～360に変更
			var temp2 =(linkButton_arr[temp].rotation + 360) % 360 ;

			//ボタンが静止していない場合はロールオーバーを受け付けず			
			if( temp2 < linkangle_arr[temp] - 1 || temp2 > linkangle_arr[temp] + 1){
				return;
			}

			now_int = 0;

			//深度調整
			//重なり合わせの不具合が起こらないように先に深度変更を行っておく
			for(var i:int = 0 ; i < linkbutton_num ; i++){
				if(temp > i)this.setChildIndex(linkButton_arr[i] , temp - i -1 + other_num);
				else this.setChildIndex(linkButton_arr[i] , linkbutton_num - 1 - i + temp + other_num);	
			}
			for(var j:int = 0 ; j < linkbutton_num ; j++){
				nextangle_arr[j] = linkangle_arr[temp];
			}

			//説明文表示
			review_text.text = review_arr[temp];

		}

		//ロールアウトイベント
		//円状の位置に戻るように目標角度調整
		function rollOutF(event:Event):void{
			now_int = 1;
			for(var i:int = 0 ; i < linkbutton_num ; i++){
				nextangle_arr[i] = linkangle_arr[i];
			}
			review_text.text = "";
		}

	}
}